/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.IQuestFactory;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public final class QuestType<D extends IQuestData, Q extends Quest<D>> {
    private final ResourceLocation id;
    private final IQuestDataResolver<D> resolver;
    private final IQuestFactory<D, Q> factory;

    public QuestType(ResourceLocation id, IQuestDataResolver<D> resolver, IQuestFactory<D, Q> factory) {
        this.id = id;
        this.resolver = resolver;
        this.factory = factory;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public CompoundNBT writeData(D data) {
        return this.resolver.serialize(data);
    }

    public D readData(CompoundNBT nbt) {
        return (D)((IQuestData)this.resolver.deserialize(nbt));
    }

    public D resolveJson(JsonElement element) throws JsonParseException {
        return (D)((IQuestData)this.resolver.resolve(element));
    }

    public Q newQuestInstance(QuestScheme<D> scheme, UUID traderId) {
        return this.factory.makeQuestInstance(scheme, traderId);
    }

    public Q fromContext(QuestDeserializationContext<D> context) {
        return this.factory.questFromContext(context);
    }

    public static interface IQuestDataResolver<D> {
        public D resolve(JsonElement var1) throws JsonParseException;

        public CompoundNBT serialize(D var1);

        public D deserialize(CompoundNBT var1);
    }
}

